﻿using System;
using System.Xml.Serialization;
using System.Runtime.Serialization;
using InfoWorld.HL7.ITS;
using System.Collections;

namespace BMS.DataContracts
{
    /// <summary>
    /// Filtering class for admissions. Contains data for quering existing admissions - intent, request and event.
    /// </summary>
    [Serializable]
    [XmlType(TypeName = "AdmissionInfo")]
    [DataContract(Name = "AdmissionInfo")]
    [KnownType(typeof(CD))]
    [KnownType(typeof(Act))]
    public class AdmissionInfo : Act
    {
        #region Public Members

        /// <summary>
        /// Gets or sets the date of the admission request.
        /// </summary>
        /// <value>
        /// The date of the request.
        /// </value>
        [XmlElementAttribute("RequestedDate", Order = 1)]
        [DataMember(EmitDefaultValue = false, Name = "RequestedDate", Order = 1)]
        public DateTime? RequestedDate { get; set; }

        /// <summary>
        /// Gets or sets the date of the removal from the waiting list.
        /// </summary>
        /// <value>
        /// The removal date.
        /// </value>
        [XmlElementAttribute("RemovedDate", Order = 2)]
        [DataMember(EmitDefaultValue = false, Name = "RemovedDate", Order = 2)]
        public DateTime? RemovedDate { get; set; }

        /// <summary>
        /// Gets or sets the problem. Name of the presented problem or diagnostic of  the patient.
        /// </summary>
        /// <value>
        /// The problem.
        /// </value>
        [XmlElementAttribute("Problem", Order = 3)]
        [DataMember(EmitDefaultValue = false, Name = "Problem", Order = 3)]
        public string Problem { get; set; }

        /// <summary>
        /// Gets or sets the type of bed or ward needed by the patient.
        /// </summary>
        /// <value>
        /// The type of bed ward.
        /// </value>
        [XmlElementAttribute("TypeOfBedWard", Order = 4)]
        [DataMember(EmitDefaultValue = false, Name = "TypeOfBedWard", Order = 4)]
        public string TypeOfBedWard { get; set; }

        /// <summary>
        /// Gets or sets the area where the patient waits for admission(EVS concept).
        /// </summary>
        /// <value>
        /// The waiting area.
        /// </value>
        [XmlElementAttribute("WaitingArea", Order = 5)]
        [DataMember(EmitDefaultValue = false, Name = "WaitingArea", Order = 5)]
        public CD WaitingArea { get; set; }

        /// <summary>
        /// Gets or sets the time spent in the waiting area.
        /// </summary>
        /// <value>
        /// The wait time.
        /// </value>
        [XmlElementAttribute("WaitTime", Order = 6)]
        [DataMember(EmitDefaultValue = false, Name = "WaitTime", Order = 6)]
        public TimeSpan? WaitTime { get; set; }        

        /// <summary>
        /// Gets or sets the received service for the fee(EVS concept).
        /// </summary>
        /// <value>
        /// The service received.
        /// </value>
        [XmlElementAttribute("ServiceReceive", Order = 7)]
        [DataMember(EmitDefaultValue = false, Name = "ServiceReceive", Order = 7)]
        public CD ServiceReceive { get; set; }

        /// <summary>
        /// Gets or sets the reason for the fee(EVS concept).
        /// </summary>
        /// <value>
        /// The reason for the fee.
        /// </value>
        [XmlElementAttribute("ReasonFee", Order = 8)]
        [DataMember(EmitDefaultValue = false, Name = "ReasonFee", Order = 8)]
        public CD ReasonFee { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether the illness is acute (fee disposition).
        /// </summary>
        /// <value>
        /// The fee disposition.
        /// </value>
        [XmlElementAttribute("FeeDisposition", Order = 9)]
        [DataMember(EmitDefaultValue = false, Name = "FeeDisposition", Order = 9)]
        public CD FeeDisposition { get; set; }

        /// <summary>
        /// Gets or sets the value indicating if the fee was authorized or not(EVS concept).
        /// </summary>
        /// <value>
        /// The authorization.
        /// </value>
        [XmlElementAttribute("Authorization", Order = 10)]
        [DataMember(EmitDefaultValue = false, Name = "Authorization", Order = 10)]
        public CD Authorization { get; set; }

        /// <summary>
        /// Gets or sets whether there is a contract concerning the fee.
        /// </summary>
        /// <value>
        /// The contract.
        /// </value>
        [XmlElementAttribute("Contract", Order = 11)]
        [DataMember(EmitDefaultValue = false, Name = "Contract", Order = 11)]
        public CD Contract { get; set; }

        /// <summary>
        /// Gets or sets the comment for the fee.
        /// </summary>
        /// <value>
        /// The comment for the fee.
        /// </value>
        [XmlElementAttribute("CommentFee", Order = 12)]
        [DataMember(EmitDefaultValue = false, Name = "CommentFee", Order = 12)]
        public string CommentFee { get; set; }

        /// <summary>
        /// Gets or sets the bed assigned to the patient(EIS place reference).
        /// </summary>
        /// <value>
        /// The assigned bed.
        /// </value>
        [XmlElementAttribute("AssignedBedId", Order = 13)]
        [DataMember(EmitDefaultValue = false, Name = "AssignedBedId", Order = 13)]
        public II AssignedBedId { get; set; }

        /// <summary>
        /// Gets or sets the date when the bed was assigned to the patient.
        /// </summary>
        /// <value>
        /// The bed assigned date.
        /// </value>
        [XmlElementAttribute("BedAssignedDate", Order = 14)]
        [DataMember(EmitDefaultValue = false, Name = "BedAssignedDate", Order = 14)]
        public DateTime? BedAssignedDate { get; set; }


        [XmlElementAttribute("IsInHouse", Order = 15)]
        [DataMember(EmitDefaultValue = false, Name = "IsInHouse", Order = 15)]
        public bool IsInHouse { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether bed is in isolation or not.
        /// </summary>
        /// <value>
        /// 	<c>true</c> if bed is in isolation; otherwise, <c>false</c>.
        /// </value>
        [XmlElementAttribute("IsBedInIsolation", Order = 16)]
        [DataMember(EmitDefaultValue = false, Name = "IsBedInIsolation", Order = 16)]
        public bool IsBedInIsolation { get; set; }

        /// <summary>
        /// Gets or sets the last edit by.
        /// </summary>
        /// <value>
        /// The last edit by.
        /// </value>
        [XmlElementAttribute("LastEditBy", Order = 17)]
        [DataMember(EmitDefaultValue = false, Name = "LastEditBy", Order = 17)]
        public string LastEditBy { get; set; }

        /// <summary>
        /// Gets or sets the waiting list comment.
        /// </summary>
        /// <value>
        /// The comment for the waiting list.
        /// </value>
        [XmlElementAttribute("Comment", Order = 18)]
        [DataMember(EmitDefaultValue = false, Name = "Comment", Order = 18)]
        public string Comment { get; set; }

        /// <summary>
        /// Gets or sets the wait time alert date.
        /// </summary>
        /// <value>
        /// The wait time alert date.
        /// </value>
        [XmlElementAttribute("WaitTimeAlertDate", Order = 19)]
        [DataMember(EmitDefaultValue = false, Name = "WaitTimeAlertDate", Order = 19)]
        public DateTime? WaitTimeAlertDate { get; set; }

        /// <summary>
        /// Gets or sets the community living center.
        /// </summary>
        /// <value>
        /// The community living center.
        /// </value>
        [XmlElementAttribute("IsCommunityLivingCenter", Order = 20)]
        [DataMember(EmitDefaultValue = false, Name = "IsCommunityLivingCenter", Order = 20)]
        public bool IsCommunityLivingCenter { get; set; }

        [XmlElementAttribute("DateOfScreening", Order = 21)]
        [DataMember(EmitDefaultValue = false, Name = "DateOfScreening", Order = 21)]
        public DateTime? DateOfScreening { get; set; }

        [XmlElementAttribute("VeteranPreference", Order = 22)]
        [DataMember(EmitDefaultValue = false, Name = "VeteranPreference", Order = 22)]
        public string VeteranPreference { get; set; }

        [XmlElementAttribute("MentalHealthComment", Order = 23)]
        [DataMember(EmitDefaultValue = false, Name = "MentalHealthComment", Order = 23)]
        public string MentalHealthComment { get; set; }

        [XmlElementAttribute("PatientFlowComment", Order = 24)]
        [DataMember(EmitDefaultValue = false, Name = "PatientFlowComment", Order = 24)]
        public string PatientFlowComment { get; set; }

        [XmlElementAttribute("TransportationComment", Order = 25)]
        [DataMember(EmitDefaultValue = false, Name = "TransportationComment", Order = 25)]
        public string TransportationComment { get; set; }

        [XmlElementAttribute("FeeAccepted", Order = 25)]
        [DataMember(EmitDefaultValue = false, Name = "FeeAccepted", Order = 25)]
        public string FeeAccepted { get; set; }

        [XmlElementAttribute("EvacExpectedPickUp", Order = 25)]
        [DataMember(EmitDefaultValue = false, Name = "EvacExpectedPickUp", Order = 25)]
        public DateTime? EvacExpectedPickUp { get; set; }

        [XmlElementAttribute("IsCommunityHospital", Order = 26)]
        [DataMember(EmitDefaultValue = false, Name = "IsCommunityHospital", Order = 26)]
        public bool IsCommunityHospital { get; set; }

        [XmlElementAttribute("TransferCoordinator", Order = 27)]
        [DataMember(EmitDefaultValue = false, Name = "TransferCoordinator", Order = 27)]
        public string TransferCoordinator { get; set; }

        [XmlElementAttribute("TransferCoordinatorPhone", Order = 28)]
        [DataMember(EmitDefaultValue = false, Name = "TransferCoordinatorPhone", Order = 28)]
        public string TransferCoordinatorPhone { get; set; }

        #endregion
    }
}
